<?php

declare(strict_types=1);

use Crossroads\Magento\Test\Integration\MagentoManager;
use PHPUnit\Framework\TestCase;

class SlackTest extends TestCase
{
    public function setUp(): void
    {
        MagentoManager::reset();
        MagentoManager::init('default');
    }

    public function tearDown(): void
    {
        MagentoManager::logQueries();
    }

    public function testNotConnected(): void
    {
        $slack = Mage::helper('awardit_slack');
        $this->assertInstanceOf(Awardit_Slack_Helper_Data::class, $slack);

        // We can only test case when not connected to Slack.
        // These calls must not cause exception, but return "empty" results.

        $empty = $slack->getAvailableChannels();
        $this->assertSame([], $empty);

        // We can only test case when not connected to Slack
        $false = $slack->postInChannel('no-such-channel', 'my message');
        $this->assertFalse($false);
    }
}
