# Message Format

This message format MUST match what is defined in our common event message type(s).

## Basic structure

An event message consists of a JSON-encoded body and some attributes.

### Body

#### `awardit.metadata`

Type: key-value map.

Metadata common to all events.

##### `id`

Type: string

The entity id the message data is describing.

##### `revision`

Type: int

The revision number of the entity the message is describing.

##### `deleted`

Type: boolean

If the entity the event is representing is now deleted.

NOTE: A new revision can resurrect deleted items by setting this field to
      `false` again.

##### `topic`

Type: string

The topic which the event was emitted on.

##### `eventType`

Type: string

The common event type name which describes the structure and contents of the
event. Used to match incoming events to the correct representation and to
version event data-structure.

### Attributes

NOTE: Number of attributes per message is limited to 10 when using AWS Simple
Notification Service (SNS) with `RawMessageDelivery` to AWS Simple Queue
Service (SQS). Without `RawMessageDelivery` no message attributes are delivered.

#### `awardit.eventType`

Type: string

The common event type name which describes the structure and contents of the
event. Used to filter events in a subscription to only subscribe to events
of particular types/versions.

#### `awardit.deleted`

Type: string-enum, `"true"` or `"false"`

If the event message represents a deleted entity.
