<?php

declare(strict_types=1);

namespace Awardit\SimpleEvent;

use Awardit\SimpleEvent\EventInterface;

/**
 * @psalm-type Options array{correlationId?:string}
 */
interface EventEmitterInterface
{
    /**
     * Updates the default correlation id to set on emitted events.
     *
     * @api
     */
    public function setCorrelationId(string $correlationId): void;

    /**
     * Emits an event.
     *
     * Options:
     *
     *   * correlationId: The tracking id associated with the originating action
     *
     * @api
     * @param Options $options
     */
    public function emit(EventInterface $event, array $options = []): void;
}
