<?php

declare(strict_types=1);

namespace Awardit\SimpleEvent\Aws;

use Awardit\Aws\Env;
use Awardit\SimpleEvent\Exception;

// TODO: Variation which takes a list of topics up front
class TopicsFromEnv implements TopicsInterface
{
    private const string DEFAULT_ENV_PREFIX = "TOPIC_ARN_";

    /**
     * @api
     */
    public function __construct(
        private string $prefix = self::DEFAULT_ENV_PREFIX
    ) {
    }

    public function getTopicArn(string $topic): string
    {
        $envName = $this->topicNameToEnv($topic);
        $value = Env::getValue($envName);

        if ($value === null) {
            throw new Exception(sprintf(
                "%s: Failed to get topic ARN for '%s' from env var '%s'.",
                __METHOD__,
                $topic,
                $envName
            ));
        }

        return $value;
    }

    private function topicNameToEnv(string $topic): string
    {
        return $this->prefix . strtoupper(strtr($topic, "-", "_"));
    }
}
