<?php

declare(strict_types=1);

namespace Awardit\SimpleEvent\Event;

use Awardit\SimpleEvent\Exception;

trait AutoRevisionedEventTrait
{
    // TODO: Allow this to be exposed when dumping the object
    /**
     * Data revision.
     *
     * Optional and writable since this event implements
     * AssignableRevisionInterface, it should be provided when constructed
     * using fromMessage.
     */
    private int|null $revision = null;

    public function setRevision(int $revision): void
    {
        if ($this->revision !== null) {
            throw new Exception(sprintf(
                "%s: Attempted to update already set revision on %s(%s)",
                __METHOD__,
                $this::class,
                $this->getEntityId()
            ));
        }

        assert($revision > 0);

        $this->revision = $revision;
    }

    public function getRevision(): int
    {
        if ($this->revision === null) {
            throw new Exception(sprintf(
                "%s: Missing revision for %s(%s), was it constructed using new?",
                __METHOD__,
                $this::class,
                $this->getEntityId()
            ));
        }

        return $this->revision;
    }
}
