<?php

declare(strict_types=1);

namespace Awardit\SimpleEvent\V1;

use Awardit\SimpleEvent\ReceivedMessageInterface;
use Awardit\SimpleEvent\Exception;

/**
 * Concrete message implementation for version 1 of a received decoded message.
 */
class ReceivedMessage implements ReceivedMessageInterface
{
    // TODO: constructor which will validate?
    private array $message;

    public function __construct(array $message)
    {
        $this->message = $message;

        assert(!array_key_exists("version", $this->message) || $this->message["version"] === 1);
        // $this->message must now be of structure from EventMessage::formatMessage
    }

    public function getMessageEventType(): string
    {
        $eventType = $this->message["meta"]["eventType"] ?? null;

        assert(is_string($eventType));

        return $eventType;
    }

    public function getEventEntityId(): string
    {
        $id = $this->message["meta"]["id"] ?? null;

        assert(is_string($id));

        return $id;
    }

    public function getEventRevision(): int
    {
        $revision = $this->message["meta"]["revision"] ?? null;

        assert(is_int($revision));

        return $revision;
    }

    public function getEventIsDeleted(): bool
    {
        $revision = $this->message["meta"]["deleted"] ?? null;

        assert(is_bool($revision));

        return $revision;
    }

    public function getEventPayload(): array
    {
        $payload = $this->message["payload"] ?? null;

        assert(is_array($payload));

        return $payload;
    }
}
