<?php

declare(strict_types=1);

namespace Awardit\SimpleEvent\Event\ProductPricingPrice;

/**
 * @psalm-type Payload array{debugId:string, title?:?string, showDiscounts:bool}
 * @readonly
 */
class Campaign
{
    /**
     * Identifier for the campaign, mainly used for debugging.
     */
    public string $debugId;
    /**
     * If to display the discounted prices.
     */
    public bool $showDiscounts;
    /**
     * Title of the campaign.
     */
    public ?string $title = null;

    /**
     * @param Payload $data
     */
    public function __construct(
        array $data
    ) {
        $this->debugId = $data["debugId"];
        $this->showDiscounts = $data["showDiscounts"];
        $this->title = $data["title"] ?? null;
    }

    /**
     * @return Payload
     */
    public function formatMessagePayload(): array
    {
        return [
            "debugId" => $this->debugId,
            "title" => $this->title,
            "showDiscounts" => $this->showDiscounts,
        ];
    }
}
