<?php

declare(strict_types=1);

namespace Awardit\SimpleEvent;

/**
 * Additional data related to a specific event.
 *
 * @readonly
 */
class Metadata
{
    private string $correlationId;
    private string $sender;

    public function __construct(
        string $correlationId,
        string $sender
    ) {
        $this->correlationId = $correlationId;
        $this->sender = $sender;
    }

    /**
     * Tracking id of the origin of the event.
     *
     * @api
     */
    public function getCorrelationId(): string
    {
        return $this->correlationId;
    }

    /**
     * The name/identifier of the service which sent the event.
     *
     * @api
     */
    public function getSender(): string
    {
        return $this->sender;
    }
}
