<?php

declare(strict_types=1);

namespace Awardit\SimpleEvent\Event;

use Awardit\SimpleEvent\ReceivedMessageInterface;
use Awardit\SimpleEvent\EventInterface;

/**
 * An event used for testing.
 *
 * @psalm-type Data array{
 *   id:string,
 *   data:array,
 *   isDeleted?:?bool,
 *   revision?:?int
 * }
 */
class TestEvent implements AutoRevisionedEventInterface, EventInterface
{
    use AutoRevisionedEventTrait;

    public static function getMessageType(): string
    {
        return "AwarditTestEventV1";
    }

    public static function getMessageTopic(): string
    {
        return "awardit-test-event";
    }

    public static function fromReceivedMessage(ReceivedMessageInterface $message): self
    {
        return new self([
            "id" => $message->getEventEntityId(),
            "revision" => $message->getEventRevision(),
            "data" => $message->getEventPayload(),
            "isDeleted" => $message->getEventIsDeleted(),
        ]);
    }

    public string $id;
    public array $data;
    public bool $isDeleted;

    /**
     * @param Data $data
     */
    public function __construct(
        array $data
    ) {
        $this->id = $data["id"];
        $this->data = $data["data"];
        $this->isDeleted = $data["isDeleted"] ?? false;
        $this->revision = $data["revision"] ?? null;
    }

    public function getEntityId(): string
    {
        return $this->id;
    }

    public function getIsDeleted(): bool
    {
        return $this->isDeleted;
    }

    public function formatMessagePayload(): array
    {
        return $this->data;
    }
}
