<?php

declare(strict_types=1);

namespace Awardit\SimpleEvent;

/**
 * A message to be sent.
 */
interface MessageInterface
{
    /**
     * Event type of the message, mapped to EventInterface::getEventType().
     */
    public function getMessageEventType(): string;

    /**
     * Message subject.
     */
    public function getMessageSubject(): string;

    /**
     * Extra attributes associated with the message.
     *
     * @return Array<string, string>
     */
    public function getMessageAttributes(): array;

    /**
     * Identifier used to deduplicate messages, if sent in a FIFO/deduplicated queue/topic.
     */
    public function getMessageDeduplicationId(): string;

    /**
     * Format the message in a way suitable for encoding (JSON/XML).
     *
     * @return Array<string, mixed>
     */
    public function formatMessage(): array;
}
