<?php

declare(strict_types=1);

namespace Awardit\SimpleEvent;

/**
 * An event representation, find concrete implementations in the
 * \Awardit\SimpleEvent\Event namespace.
 *
 * Preferably the methods of the implementation should be used
 * by producers and consumers of the events.
 */
interface EventInterface
{
    /**
     * This static method validates an incoming message and construct an
     * instance of the event.
     *
     * @internal
     */
    public static function fromReceivedMessage(ReceivedMessageInterface $message): self;

    /**
     * The event topic associated with this class.
     */
    public static function getEventTopic(): string;

    /**
     * The event data type associated with this class.
     *
     * Note that event type != event topic, a topic can contain multiple event
     * types with the same data in different configurations. This allows us to
     * do graceful updates across services.
     */
    public static function getEventType(): string;


    // TODO: Move to Message
    /**
     * The entity id of the data contained in the event.
     *
     * @api
     */
    public function getEntityId(): string;
    /**
     * The revision of the entity contained in the event data.
     *
     * @api
     */
    public function getRevision(): int;
    /**
     * Returns true if the content of the message represents a deleted item.
     *
     * @api
     */
    public function getIsDeleted(): bool;
    /**
     * The plain event data.
     *
     * NOTE: The EventEmitter will use getEntityId, getRevision, getIsDeleted
     *       and provide that in metadata.
     *
     * @internal
     */
    public function getPayload(): array;
}
