<?php

declare(strict_types=1);

namespace Awardit\SimpleEvent;

use Awardit\SimpleEvent\EventInterface;

/**
 * @psalm-type Options array{correlationId?:string}
 */
interface EventEmitterInterface
{
    /**
     * Emits an event.
     *
     * Options:
     *
     *   * correlationId: The tracking id associated with the originating action
     *
     * @param Options&Array<string, mixed> $options
     */
    public function emit(EventInterface $event, array $options = []): void;
}
