<?php

declare(strict_types=1);

namespace Awardit\SimpleEvent\Event;

use Awardit\SimpleEvent\Exception;
use Awardit\SimpleEvent\EventInterface;

/**
 * Interface indicating that an event can have its revision reassigned
 * automatically using AutoRevisionManager.
 */
interface AutoRevisionedEventInterface extends EventInterface
{
    /**
     * Updates the revision on an event, only allowed if the revision is not
     * already set.
     *
     * @internal
     * @throws Exception if the event is already set.
     */
    public function setRevision(int $revision): void;
}
