<?php

declare(strict_types=1);

namespace Awardit\SimpleEvent;

/**
 * NOTE: We have to be careful about which attributes we add, there is a limit
 * to 10 while using RawMessageDelivery to SQS.
 */
class Attributes
{
    /**
     * The sender of the event.
     *
     * @api
     * @public
     */
    public const SENDER = "awardit.sender";
    /**
     * Attribute indicating if the entity in the message is now deleted.
     *
     * Type: String enum ("true" or "false")
     *
     * @internal
     */
    public const DELETED = "awardit.deleted";
    /**
     * Event type name, globally defined structure.
     *
     * Type: string
     *
     * @internal
     */
    public const EVENT_TYPE = "awardit.eventType";
}
