<?php

declare(strict_types=1);

use Awardit\Aws\Logger;
use Awardit\Aws\Util;
use Awardit\SimpleEvent\Attributes;
use Awardit\SimpleEvent\Aws\SnsEventEmitter;
use Awardit\SimpleEvent\Aws\SqsEventListener;
use Awardit\SimpleEvent\Aws\TopicsFromEnv;
use Awardit\SimpleEvent\EventHandlerInterface;
use Awardit\SimpleEvent\EventInterface;
use Awardit\SimpleEvent\EventRegistry;
use Awardit\SimpleEvent\Event\TestEvent;
use Awardit\SimpleEvent\Metadata;
use Aws\Sdk;
use Dotenv\Dotenv;

require_once dirname(__DIR__) . "/vendor/autoload.php";

Logger::registerErrorHandler();

// Configuration from environment
// We use createUnsafeImmutable to also override getenv() which the AWS SDK uses
Dotenv::createUnsafeImmutable(dirname(__DIR__))->safeLoad();

$sqsQueue = Util::mustGetEnvValue("SQS_QUEUE_URL");
$log = Logger::getLogger("simple-event");
$sdk = new Sdk(Util::getAwsSdkCommonConfig());

$emitter = new SnsEventEmitter(
    log: $log,
    client: $sdk->createSns(),
    topics: new TopicsFromEnv(),
    sender: "example-simple-event-aws-basic",
    correlationId: bin2hex(random_bytes(32)),
);
$listener = new SqsEventListener(
    log: $log,
    client:$sdk->createSqs(),
    queueUrl: $sqsQueue,
    registry: EventRegistry::withDefaults(),
);

$emitter->emit(new TestEvent(
    id: "a-test-event-id",
    revision: time(),
    data: [
        "some data" => "this is test message",
    ],
));

$listener->receiveEvents(new class implements EventHandlerInterface {
    public function handle(EventInterface $event, Metadata $meta): bool
    {
        var_dump($event);

        // True indicates that we are done processing the message and want to delete it
        return true;
    }
});
