<?php

declare(strict_types=1);

namespace Awardit\SimpleEvent;

/**
 * Event handler.
 */
interface EventHandlerInterface
{
    /**
     * Handles a single event.
     *
     * NOTE: Errors/Exceptions will be handled by surrounding runtime.
     *
     * @return bool Return true if the event was handled and should be removed
     */
    public function handle(EventInterface $event, Metadata $meta): bool;

    /**
     * Get last error message if handle() failed.
     *
     * @return string Error message, empty string if not set
     */
    public function getLastError(): string;
}
