<?php

declare(strict_types=1);

namespace Awardit\SimpleEvent\Event;

use Awardit\SimpleEvent\ReceivedMessageInterface;
use Awardit\SimpleEvent\EventInterface;

/**
 * An event used for testing.
 */
class TestEvent implements AutoRevisionedEventInterface, EventInterface
{
    use AutoRevisionedEventTrait;

    public static function getMessageType(): string
    {
        return "AwarditTestEventV1";
    }

    public static function getMessageTopic(): string
    {
        return "awardit-test-event";
    }

    public static function fromReceivedMessage(ReceivedMessageInterface $message): self
    {
        return new self(
            id: $message->getEventEntityId(),
            revision: $message->getEventRevision(),
            data: $message->getEventPayload(),
            isDeleted: $message->getEventIsDeleted(),
        );
    }

    public function __construct(
        readonly public string $id,
        readonly public array $data,
        readonly public bool $isDeleted = false,
        int $revision = null
    ) {
        $this->revision = $revision;
    }

    public function getEntityId(): string
    {
        return $this->id;
    }

    public function getIsDeleted(): bool
    {
        return $this->isDeleted;
    }

    public function formatMessagePayload(): array
    {
        return ["id" => $this->id, ...$this->data];
    }
}
