# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.1.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [0.2.6] - 2024-11-16

### Added

- `ErpProduct`.`supplier` containing supplier name, if available.
- `ErpProduct`.`supplierSku` containing supplier SKU, if available.
- `ErpPRoduct`.`brand` containing product brand, if available.

## [0.2.5] - 2024-10-08

### Added
- Created `Aws\Localstack\LocalSqsConsumer`: Handler-consumer-Jack-of-all-trades class
  for simply handling SQS messages during local development.

## [0.2.4] - 2024-09-27

### Changes

- Upgraded `awardit/aws` to `^0.3.0`

## [0.2.3] - 2024-09-27

### Added

- `Event\ErpProduct`: `type` is now `"physical"`, `"virtual"`, and `"dropship"`.
- `Event\ErpProduct` now has `categories` with a list of product category paths.

### Fixed

- AWS SQS WaitTimeSeconds is now correctly restricted to the range 0 - 20.
- `SqsEventListener` now properly sets WaitTimeSeconds.

## [0.2.2] - 2024-06-17

### Added

- `Aws\Lambda\SqsHandler`: Includes complete SQS record information for failed events.
- `Event\ErpProduct`: Also includes `revision` when dumped to JSON.
- `EventEmitter\AutoRevisionedEmitter`: `debugLogFullPayload` optional constructor parameter
  which will log the full Lambda payload for each Lambda-request.
- Aws\Lambda\SqsHandler`: Proper `batchItemFailures`-reporting to Lambda.

### Changed

- Major changes to work-in-progress `ProductPricingPrice` event

### Fixed

- JSON parse errors in `EventEmitter\AutoRevisionedEmitter` are now properly handled.
- Type-error with int vs string in `EventEmitter\AutoRevisionedEmitter` from Redis.

## [0.2.1] - 2024-05-27

### Added

- Added `ProductPricingPrice` event, work in progress.

## [0.2.0] - 2024-05-06

### Changed

- Updated awardit/aws library

## [0.1.0] - 2024-05-06

### Added

- Initial Release
