<?php

declare(strict_types=1);

namespace Awardit\SimpleEvent\Aws;

class Helper
{
    /**
     * @param Array<string, string|int|float> $attributes
     */
    public static function buildAttributes(array $attributes): array
    {
        $messageAttributes = [];

        foreach ($attributes as $k => $v) {
            $messageAttributes[$k] = [
                "DataType" => (is_int($v) || is_float($v)) ? "Number" : "String",
                "StringValue" => (string)$v,
            ];
        }

        return $messageAttributes;
    }
}
