<?php

class Awardit_S3ResizeProxy_Shell_Export
{
    public function __construct()
    {
        $this->_validate();
    }

    protected function _validate()
    {
        $errors = [];

        /** @var Awardit_S3ResizeProxy_Shell_Helper_Data $helper */
        $helper = Mage::helper('awardit_s3resizeproxy');
        var_dump(get_class($helper));
        if (is_null($helper->getAccessKey())) {
            $errors[] = 'You have not provided an AWS access key ID. You can do so using our config script.';
        }
        if (is_null($helper->getSecretKey())) {
            $errors[] = 'You have not provided an AWS secret access key. You can do so using our config script.';
        }
        if (is_null($helper->getBucket())) {
            $errors[] = 'You have not provided an S3 bucket. You can do so using our config script.';
        }
        if (is_null($helper->getRegion())) {
            $errors[] = 'You have not provided an S3 region. You can do so using our config script.';
        }
        if (!$helper->getClient()->isBucketAvailable($helper->getBucket())) {
            $errors[] = 'The AWS credentials you provided did not work. Please review your details and try again. You can do so using our config script.';
        }

        if (!empty($errors)) {
            foreach ($errors as $error) {
                echo $error . "\n";
                die();
            }
        }
    }

    public function run()
    {
        /** @var Mage_Core_Helper_File_Storage $helper */
        $helper = Mage::helper('core/file_storage');

        // Stop S3 from syncing to itself
        if (Thai_S3_Model_Core_File_Storage::STORAGE_MEDIA_S3 == $helper->getCurrentStorageCode()) {
            echo "\033[1mYou cannot sync from S3 to itself!\033[0m\n\nYou are already using S3 as your media file storage backend! Please revert\nback to using the previous storage backend before trying again.\n";

            return $this;
        }

        /** @var Mage_Core_Model_File_Storage_File|Mage_Core_Model_File_Storage_Database $sourceModel */
        $sourceModel = $helper->getStorageModel();

        /** @var Thai_S3_Model_Core_File_Storage_S3 $destinationModel */
        $destinationModel = $helper->getStorageModel(Thai_S3_Model_Core_File_Storage::STORAGE_MEDIA_S3);

        $offset = 0;
        $count = 1;
        while (($files = $sourceModel->exportFiles($offset, $count)) !== false) {
            foreach ($files as $file) {
                echo sprintf("Uploading %s to S3.\n", $file['directory'] . '/' . $file['filename']);
            }
            $destinationModel->importFiles($files);
            $offset += $count;
        }
        unset($files);

        return $this;
    }
}