<?php

class Awardit_S3ResizeProxy_Helper_Data extends Thai_S3_Helper_Data
{
    /**
     * Returns the AWS access key.
     *
     * @return string
     */
    public function getAccessKey()
    {
        return Mage::getStoreConfig('awardit_s3resizeproxy/general/access_key');
    }

    /**
     * Returns the AWS secret key.
     *
     * @return string
     */
    public function getSecretKey()
    {
        return Mage::getStoreConfig('awardit_s3resizeproxy/general/secret_key');
    }

    /**
     * Returns the AWS region that we're using, e.g. ap-southeast-2.
     *
     * @return string
     */
    public function getRegion()
    {
        return Mage::getStoreConfig('awardit_s3resizeproxy/general/region');
    }

    /**
     * Returns the S3 bucket where we want to store all our images.
     *
     * @return string
     */
    public function getBucket()
    {
        return Mage::getStoreConfig('awardit_s3resizeproxy/general/bucket');
    }

    /**
     * Returns the string that we want to prepend to all of our S3 object keys.
     *
     * @return string
     */
    public function getPrefix()
    {
        return Mage::getStoreConfig('awardit_s3resizeproxy/general/prefix');
    }

    /**
     * @return bool
     */
    public function getCustomEndpointEnabled()
    {
        return (bool)Mage::getStoreConfig('awardit_s3resizeproxy/general/custom_endpoint_enabled');
    }

    /**
     * @return string
     */
    public function getCustomEndpoint()
    {
        return Mage::getStoreConfig('awardit_s3resizeproxy/general/custom_endpoint');
    }
}