<?php

class Awardit_S3ResizeProxy_Shell_Import
{
    public function __construct()
    {
        $this->_validate();
    }

    protected function _validate()
    {
        $errors = [];

        /** @var Awardit_S3ResizeProxy_Shell_Helper_Data $helper */
        $helper = Mage::helper('awardit_s3resizeproxy');
        if (is_null($helper->getAccessKey())) {
            $errors[] = 'You have not provided an AWS access key ID. You can do so using our config script.';
        }
        if (is_null($helper->getSecretKey())) {
            $errors[] = 'You have not provided an AWS secret access key. You can do so using our config script.';
        }
        if (is_null($helper->getBucket())) {
            $errors[] = 'You have not provided an S3 bucket. You can do so using our config script.';
        }
        if (is_null($helper->getRegion())) {
            $errors[] = 'You have not provided an S3 region. You can do so using our config script.';
        }
        if (!$helper->getClient()->isBucketAvailable($helper->getBucket())) {
            $errors[] = 'The AWS credentials you provided did not work. Please review your details and try again. You can do so using our config script.';
        }

        if (!empty($errors)) {
            foreach ($errors as $error) {
                echo $error . "\n";
                die();
            }
        }
    }

    public function run()
    {
        /** @var Mage_Core_Helper_File_Storage $helper */
        $helper = Mage::helper('core/file_storage');

        // Stop S3 from syncing to itself
        if (Thai_S3_Model_Core_File_Storage::STORAGE_MEDIA_S3 != $helper->getCurrentStorageCode()) {
            echo "\033[1mYou are currently not using S3!\033[0m\n\nYou are not using S3 as your media file storage backend! Reverting from using S3\nto using the local file system backend is not necessary.\n";

            return $this;
        }

        /** @var Thai_S3_Model_Core_File_Storage_S3 $sourceModel */
        $sourceModel = $helper->getStorageModel(Thai_S3_Model_Core_File_Storage::STORAGE_MEDIA_S3);

        /** @var Mage_Core_Model_File_Storage_File $destinationModel */
        $destinationModel = $helper->getStorageModel(Mage_Core_Model_File_Storage::STORAGE_MEDIA_FILE_SYSTEM);

        $offset = 0;
        while (($files = $sourceModel->exportFiles($offset, 1)) !== false) {
            foreach ($files as $file) {
                echo sprintf("Importing %s from S3.\n", $file['directory'] . '/' . $file['filename']);
            }
            $destinationModel->importFiles($files);
            $offset += count($files);
        }
        unset($files);

        return $this;
    }
}