<?php

class Awardit_S3ResizeProxy_Helper_Image extends Mage_Catalog_Helper_Image {
    /**
     * Return Image URL
     *
     * @return string
     */
    public function __toString()
    {
        try {
            $model = $this->_getModel();
            if ($this->getImageFile()) {
                $model->setBaseFile($this->getImageFile());
            } else {
                $model->setBaseFile($this->getProduct()->getData($model->getDestinationSubdir()));
            }

            $baseDir = Mage::getBaseDir('media');
            $path = array();

            if ((!empty($model->getWidth())) || (!empty($model->getHeight()))) {
                $path[] = 'img';
                $path[] = "{$model->getWidth()}x{$model->getHeight()}";
            }

            $path[] = str_replace($baseDir . DS, "", $model->getBaseFile());
            return Mage::getBaseUrl('media') . str_replace(DS, '/', implode('/', $path));
        } catch (Exception $e) {
            Mage::logException($e);
            $url = Mage::getDesign()->getSkinUrl($this->getPlaceholder());
        }
        return $url;
    }
}
