<?php

declare(strict_types=1);

use Crossroads\Magento\Test\Integration\TestCase;

class Awardit_S3ResizeProxy_Test_Helper_Image_Test extends TestCase
{
    public function testHelperImage(): void
    {
        $this->initMagento();
        $image = (new Awardit_S3ResizeProxy_Helper_Image())->init(Mage::getModel("catalog/product"), "small_image");
        $image->resize(120, 105);
        $this->assertEquals(sprintf("%simg/120x105/catalog/product/placeholder.jpg", Mage::getBaseUrl('media')), (string)$image);
    }
}