<?php

class Awardit_S3ResizeProxy_Helper_Data extends Thai_S3_Helper_Data
{
    /**
     * @return Zend_Service_Amazon_S3
     * @throws Zend_Service_Amazon_S3_Exception
     */
    public function getClient()
    {
        var_dump([
            $this->getAccessKey(),
            $this->getSecretKey(),
            $this->getRegion(),
        ]);
        //var_dump(Mage::app()->getStore()->getConfig());
        return parent::getClient();
        if (is_null($this->client)) {
            $this->client = new Zend_Service_Amazon_S3(
                $this->getAccessKey(),
                $this->getSecretKey(),
                $this->getRegion()
            );
            if ($this->getCustomEndpointEnabled()) {
                $this->client->setEndpoint($this->getCustomEndpoint());
            }
        }
        return $this->client;
    }

    /**
     * Returns the AWS access key.
     *
     * @return string
     */
    public function getAccessKey()
    {
        return Mage::getStoreConfig('awardit_s3resizeproxy/general/access_key');
    }

    /**
     * Returns the AWS secret key.
     *
     * @return string
     */
    public function getSecretKey()
    {
        return Mage::getStoreConfig('awardit_s3resizeproxy/general/secret_key');
    }

    /**
     * Returns the AWS region that we're using, e.g. ap-southeast-2.
     *
     * @return string
     */
    public function getRegion()
    {
        return Mage::getStoreConfig('awardit_s3resizeproxy/general/region');
    }

    /**
     * Returns the S3 bucket where we want to store all our images.
     *
     * @return string
     */
    public function getBucket()
    {
        return Mage::getStoreConfig('awardit_s3resizeproxy/general/bucket');
    }

    /**
     * Returns the string that we want to prepend to all of our S3 object keys.
     *
     * @return string
     */
    public function getPrefix()
    {
        return Mage::getStoreConfig('awardit_s3resizeproxy/general/prefix');
    }

    /**
     * @return bool
     */
    public function getCustomEndpointEnabled()
    {
        return (bool)Mage::getStoreConfig('awardit_s3resizeproxy/general/custom_endpoint_enabled');
    }

    /**
     * @return string
     */
    public function getCustomEndpoint()
    {
        return Mage::getStoreConfig('awardit_s3resizeproxy/general/custom_endpoint');
    }
}