<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;
use MageQL\Context;

/**
 * @psalm-suppress PossiblyUnusedProperty
 */
class Awardit_S3ResizeProxy_Mageql_Model_Attributes_Image_Category extends MageQL_Catalog_Model_Attributes_Image_Category
{
    public function getSrc(array $args, Context $context, ResolveInfo $info): string {
        $resize = array_key_exists("height", $args) || array_key_exists("width", $args);
        $model = Mage::getModel("mageql_catalog/category_image");

        if($resize) {
            // We need to set this before setBaseFile since that will set the
            // filename for the resized file
            if (array_key_exists("height", $args)) {
                  $model->setHeight($args["height"]);
            }

            if (array_key_exists("width", $args)) {
                  $model->setWidth($args["width"]);
            }
        }

        //$model->setDestinationSubdir($this->attrCode);
        $model->setKeepFrame($args["fill"] ?? false);
        $model->setBaseFile($this->value);

        $baseDir = Mage::getBaseDir('media');
        $path = array();

        if ((!empty($model->getWidth())) || (!empty($model->getHeight()))) {
            $path[] = 'img';
            $path[] = "{$model->getWidth()}x{$model->getHeight()}";
        }

        $path[] = str_replace($baseDir . DS, "", $model->getBaseFile());
        return Mage::getBaseUrl('media') . str_replace(DS, '/', implode('/', $path));
    }
}
