<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;
use MageQL\Context;

class Awardit_S3ResizeProxy_Mageql_Model_Attributes_Category extends MageQL_Catalog_Model_Attributes_Category
{
    /**
     * Constructor for image-wrapper.
     *
     * @param Mage_Catalog_Model_Category $src
     * @return MageQL_Core_Model_Attributes_Image_Abstract
     */
    public function createImageWrapper(
        $src,
        Context $ctx,
        ResolveInfo $info,
        string $attrCode,
        string $value
    ): MageQL_Core_Model_Attributes_Image_Abstract {
        return new Awardit_S3ResizeProxy_Mageql_Model_Attributes_Image_Category($src, $attrCode, $value);
    }
}
