<?php

declare(strict_types=1);

class Awardit_ReleaseDate_Model_Observer {
    public function productBeforeSave(Varien_Event_Observer $observer): void {
        /**
         * @var Awardit_ReleaseDate_ProductExtension
         */
        $product = $observer->getEvent()->getProduct();

        // Approximate comparison since these can be numeric strings from admin UI
        if($product->getStatus() == Mage_Catalog_Model_Product_Status::STATUS_ENABLED &&
            $product->getOrigData("status") == Mage_Catalog_Model_Product_Status::STATUS_DISABLED &&
            empty($product->getReleaseDate())) {
            $timezone = (string)Mage::app()
                ->getStore($product->getStoreId())
                ->getConfig(Mage_Core_Model_Locale::XML_PATH_DEFAULT_TIMEZONE);

            $datetime = new DateTime("now", new DateTimeZone($timezone));

            $product->setReleaseDate($datetime->format(Varien_Date::DATETIME_PHP_FORMAT));
        }
    }
}
