<?php

declare(strict_types=1);

class Awardit_ReleaseDate_Model_Entity_Attribute_Backend_Datetime extends Mage_Eav_Model_Entity_Attribute_Backend_Datetime {
    /**
     * Prepare date for save in DB
     *
     * @param string | int $date
     * @return ?string
     */
    public function formatDate($date) {
        $date = trim((string)$date);

        if(empty($date)) {
            return null;
        }

        $timezone = (string)Mage::app()->getStore()->getConfig(Mage_Core_Model_Locale::XML_PATH_DEFAULT_TIMEZONE);

        if(preg_match('#^\d{4}-\d{1-2}-\d{1-2} \d{2}:\d{2}:\d{2}$#', $date)) {
            $datetime = DateTime::createFromFormat("Y-m-d H:i:s", $date, new DateTimeZone($timezone));
        }
        elseif(preg_match('#^\d{4}-\d{1-2}-\d{1-2} \d{2}:\d{2}$#', $date)) {
            $datetime = DateTime::createFromFormat("Y-m-d H:i", $date, new DateTimeZone($timezone));
        }
        elseif(preg_match('#^\d{4}-\d{1-2}-\d{1-2}$#', $date)) {
            $datetime = DateTime::createFromFormat("Y-m-d", $date, new DateTimeZone($timezone));
        }
        else {
            return null;
        }

        return $datetime->format(Varien_Date::DATETIME_PHP_FORMAT);
    }
}
