<?php

class Awardit_ProductEmail_Model_Observer extends Mage_Core_Model_Abstract {
    /**
     * Observer listening to `sales_order_place_after` to possibly send emails.
     */
    public function salesOrderPlaceAfter(Varien_Event_Observer $observer): void {
        /** @var Mage_Sales_Model_Order */
        $order = $observer->getOrder();

        // Load SKU/template map
        $map = $this->getSkuTemplateMap();
        if (empty($map)) {
            return; // Nothing to do here
        }

        // Load available email templates
        $templates = $this->getTemplates();
        if (empty($templates)) {
            return; // Nothing to do here
        }

        // Init mail queue
        $queue = Mage::getModel('core/email_queue');
        $queue->setEntityId($order->getId())
            ->setEntityType(Mage_Sales_Model_Order::ENTITY)
            ->setEventType('product_confirmation');

        // Traverse products, and email tempalte on matching SKU:s
        foreach ($order->getItemsCollection() as $item) {
            $product = $item->getProduct();
            $sku = $product->getSku();
            if (!array_key_exists($sku, $map)) {
                continue; // Product not mapped to template
            }
            $template_id = $map[$sku];
            if (!array_key_exists($template_id, $templates)) {
                continue; // Template do not exist (might have been removed)
            }
            $template = $templates[$template_id];
            $template->setQueue($queue);

            $result = $template->sendTransactional(
                $template_id,
                'general',
                $order->getCustomerEmail(),
                Mage::helper('customer')->getFullCustomerName($order),
                [
                    'customer'        => Mage::helper('customer')->getFullCustomerName($order),
                    'customerEmail'   => $order->getCustomerEmail(),
                    'billingAddress'  => $order->getBillingAddress(),
                    'shippingAddress' => $order->getShippingAddress(),
                    'product'         => $product,
                    'item'            => $item,
                    'order'           => $order,
                ]
            );
        }
    }

    private function getTemplates(): array {
        $templates = [];
        $collection = Mage::getModel('core/email_template')->getCollection() ?: [];
        foreach ($collection as $template) {
            $templates[$template->getId()] = $template;
        }
        return $templates;
    }

    private function getSkuTemplateMap(): array {
        $unserializer = Mage::helper("core/unserializeArray");
        /** @var string */
        $map = Mage::getStoreConfig('awardit_productemail/awardit_productemail_confirmation/confirmation_template');
        $map = $unserializer->unserialize($map);
        /** @var array<string, string> */
        $return = [];
        foreach ($map as $item) {
            if (empty($item['sku']) || empty($item['email_template_id'])) {
                continue; // Not a valid connection
            }
            $return[$item['sku']] = $item['email_template_id'];
        }
        return $return;
    }
}
