<?php

class Awardit_ProductEmail_Block_Adminhtml_Form_Field_TemplateMap
    extends Mage_Adminhtml_Block_System_Config_Form_Field_Array_Abstract
{
    /**
     * @var Awardit_ProductEmail_Block_Adminhtml_Form_Field_EmailTemplates|null
     */
    private $renderer = null;

    /**
     * Retrieve email templates
     * @return Awardit_ProductEmail_Block_Adminhtml_Form_Field_EmailTemplates
     */
    protected function getTemplates(): Awardit_ProductEmail_Block_Adminhtml_Form_Field_EmailTemplates
    {
        if (is_null($this->renderer)) {
            $layout = $this->getLayout();
            if ($layout === null) {
                throw new Exception("Found no layout to render!");
            }
            $this->renderer = $layout->createBlock(
                'awardit_productemail/adminhtml_form_field_emailTemplates',
                '',
                ['is_render_to_js_template' => true]
            );
            $this->renderer->setClass('customer_group_select');
            $this->renderer->setExtraParams('style="width:250px"');
        }
        return $this->renderer;
    }

    /**
     * Prepare to render
     */
    protected function _prepareToRender(): void
    {
        $helper = Mage::helper('awardit_productemail');
        $this->addColumn('sku', [
            'label' => $helper->__('SKU'),
            'style' => 'width:100px',
        ]);
        $this->addColumn('email_template_id', [
            'label' => $helper->__('Email template'),
            'renderer' => $this->getTemplates(),
        ]);
        $this->_addAfter = false;
        $this->_addButtonLabel = $helper->__('Add email template');
    }

    /**
     * Prepare existing row data object
     * @param Varien_Object $row
     */
    protected function _prepareArrayRow(Varien_Object $row): void
    {
        $row->setData(
            'option_extra_attr_' . $this->getTemplates()->calcOptionHash($row->getData('email_template_id')),
            'selected="selected"'
        );
    }
}
