<?php

class Awardit_ProductEmail_Block_Adminhtml_Form_Field_EmailTemplates
    extends Mage_Core_Block_Html_Select
{
    /* @var $templates array|null */
    private $templates = null;

    /**
     * Retrieve email templates
     * @return array
     */
    protected function getTemplates(): array
    {
        if (is_null($this->templates)) {
            $this->templates = [];
            $collection = Mage::getModel('core/email_template')->getCollection() ?: [];
            foreach ($collection as $template) {
                /* @var $template Mage_Customer_Model_Email_Template $template */
                $this->templates[$template->getId()] = $template->getTemplateCode();
            }
        }
        return $this->templates;
    }

    /**
     * @param string $value
     * @return Awardit_ProductEmail_Block_Adminhtml_Form_Field_EmailTemplates
     */
    public function setInputName($value): Mage_Core_Block_Html_Select
    {
        return $this->setName($value);
    }

    /**
     * Render block HTML
     * @return string
     */
    public function _toHtml(): string
    {
        if (!$this->getOptions()) {
            $this->addOption("", "-");
            foreach ($this->getTemplates() as $template_id => $template_label) {
                $this->addOption($template_id, addslashes($template_label));
            }
        }
        return parent::_toHtml();
    }
}
