<?php

declare(strict_types=1);

use MageQL\Registry;
use MageQL\Type\AbstractBuilder;

class Awardit_PopupBanner_Model_Schema extends MageQL_Core_Model_Schema_Abstract {

    public function getTypeBuilder(string $typeName, Registry $registry): ?AbstractBuilder {
        switch($typeName) {
        case "PopUpContent":
            return $this->object("Information to display in a pop-up with customer information");
        }

        return null;
    }

    public function getTypeFields(string $typeName, Registry $registry): array {
        switch($typeName) {
        case "StoreInfo":
            return [
                "popUp" => $this->field(
                    "PopUpContent",
                    "Information to show the customer in a pop-up (floating window, banner or similar) when visiting the store"
                )
                    ->setResolver(function(): ?array {
                        $enabled = (bool)Mage::getStoreConfig('awardit_popupbanner/popup_banner/enabled');
                        if (!$enabled) return null;
                        return [
                             "enabled" => $enabled,
                             "body" => Mage::getStoreConfig('awardit_popupbanner/popup_banner/body'),
                        ];
                    }),

            ];
        case "PopUpContent":
            return [
                "body" => $this->field("String", "Information to display in a pop-up with customer information")
                    ->setResolver(function($popup): string {
                        return $popup["body"];
                    }),
            ];
        }

        return [];
    }
}
