<?php

/**
 * @psalm-scope-this Mage_Customer_Model_Entity_Setup
 */
$setup = $this;

$setup->startSetup();

$entityTypeId = $setup->getEntityTypeId("customer");
$attributeSetId = $setup->getDefaultAttributeSetId($entityTypeId);
$attributeGroupId = $setup->getDefaultAttributeGroupId($entityTypeId, $attributeSetId);

$setup->addAttribute("customer", "awardit_visit_number",  array(
    "type" => "int",
    "nullable" => true,
    "backend"  => "",
    "label" => "Awardit Visit Number",
    "input" => "text",
    "source" => "",
    "sort_order" => 270,
    "visible" => true,
    "required" => false,
    "default" => null,
    "frontend" => "",
    "unique" => false,
    "note" => "Number of times the customer have visited the site.",
));

$setup->addAttributeToGroup(
    $entityTypeId,
    $attributeSetId,
    $attributeGroupId,
    "awardit_visit_number",
    270
);

// We need to manually add the attribute here to be able to see it in admin
$attribute = Mage::getSingleton("eav/config")->getAttribute("customer", "awardit_visit_number");

if( ! $attribute) {
    throw new Exception("Could not load customer attribute awardit_visit_number");
}

$attribute->setData("used_in_forms", ["adminhtml_customer"]);

$attribute->save();

$setup->endSetup();