<?php

$setup = new Mage_Eav_Model_Entity_Setup("core_setup");

$entityTypeId = $setup->getEntityTypeId("customer");
$attributeSetId = $setup->getDefaultAttributeSetId($entityTypeId);
$attributeGroupId = $setup->getDefaultAttributeGroupId($entityTypeId, $attributeSetId);

$setup->addAttribute("customer", "awardit_points",  array(
    "type" => "int",
    "backend"  => "",
    "label" => "Awardit Points",
    "input" => "text",
    "source" => "",
    "sort_order" => 200,
    "visible" => true,
    "required" => false,
    "default" => 0,
    "frontend" => "",
    "unique" => false,
    "note" => "Awardit points available to consume, will be updated upoon login and checkout",
));

$setup->addAttributeToGroup(
    $entityTypeId,
    $attributeSetId,
    $attributeGroupId,
    "awardit_points",
    300
);

// We need to manually add the attribute here to be able to see it in admin
$attribute = Mage::getSingleton("eav/config")->getAttribute("customer", "awardit_points");

if( ! $attribute) {
    throw new Exception("Could not load customer attribute awardit_points");
}

$attribute->setData("used_in_forms", ["adminhtml_customer"]);
$attribute->save();

