<?php

declare(strict_types=1);

/**
 * @method int getEntityId()
 * @method self setEntityId(int $id)
 * @method int getReservationId()
 * @method self setReservationId(int $id)
 * @method string getStatus()
 * @method self setStatus(string $status)
 * @method string getFolkspelCustomerId()
 * @method self setFolkspelCustomerId(string $id)
 * @method int getQuoteId()
 * @method self setQuoteId(int $id)
 * @method string getOrderIncrementId()
 * @method self setOrderIncrementId(string $incrementId)
 * @method int getPoints()
 * @method self setPoints(int $points)
 * @method float getAmount()
 * @method self setAmount(float $amount)
 * @method float getRate()
 * @method self setRate(float $rate)
 * @method string getCurrencyCode()
 * @method self setCurrencyCode(string $code)
 * @method int getNewBalance()
 * @method self setNewBalance(int $balance)
 * @method bool getIsTest()
 * @method self setIsTest(bool $test)
 * @method string getCreatedAt()
 * @method string getUpdatedAt()
 * @psalm-suppress PropertyNotSetInConstructor
 */
class Crossroads_FolkspelPoints_Model_Reservation extends Mage_Core_Model_Abstract
{
    public const STATUS_OPEN = "open";
    public const STATUS_COMPLETE = "complete";

    /**
     * @return void
     */
    public function _construct()
    {
        parent::_construct();

        $this->_init("folkspel_points/reservation");
    }

    protected function _beforeSave()
    {
        parent::_beforeSave();

        $this->setData("updated_at", date("Y-m-d\\TG:i:s"));

        return $this;
    }
}
