<?php

declare(strict_types=1);

use MageQL\Registry;
use MageQL\Type\AbstractBuilder;

class Awardit_Points_Model_Internal_Schema extends MageQL_Core_Model_Schema_Abstract
{
    public function getTypeBuilder(string $typeName, Registry $registry): ?AbstractBuilder
    {
        /** @var Mage_Core_Model_Store */
        $store = Mage::app()->getStore();

        if (! Mage::helper("awardit_points")->isEnabled($store)) {
            return null;
        }

        switch ($typeName) {
            case "InternalAwarditSession":
                return $this->object("Session information for Awardit");
        }

        return null;
    }

    public function getTypeFields(string $typeName, Registry $registry): array
    {
        /** @var Mage_Core_Model_Store */
        $store = Mage::app()->getStore();

        if (! Mage::helper("awardit_points")->isEnabled($store)) {
            return [];
        }

        switch ($typeName) {
            case "InternalAwarditSession":
                return [
                "memberId" => $this->field("String!", "Awardit member id")
                    ->setResolver(function (Varien_Object $obj): string {
                        return $obj->getData("memberId");
                    }),
                "partneruserid" => $this->field("Int!", "Awardit partner id")
                    ->setResolver(function (Varien_Object $obj) {
                        return (int)$obj->getData("partneruserid");
                    }),
                "JSESSIONID" => $this->field("String!", "Awardit Java Session id")
                    ->setResolver(function (Varien_Object $obj): string {
                        return $obj->getData("JSESSIONID");
                    }),
                "Cookie_2fa" => $this->field("String", "Awardit Java Device Session for 2FA")
                    ->setResolver(function (Varien_Object $obj): ?string {
                        return $obj->getData("Cookie_2fa");
                    }),
            ];

            case "Query":
                return [
                "internalAwarditPartneruserid" => $this->field("Int!", "Default partneruserid for the store partner, use internalAwarditSession if logged in")
                    ->setResolver("Awardit_Points_Model_Internal_Schema::resolveInternalAwarditPartneruserid"),
                "internalAwarditSession" => $this->field("InternalAwarditSession", "Current awardit session")
                    ->setResolver("Awardit_Points_Model_Internal_Schema::resolveInternalAwarditSession"),
            ];
        }

        return [];
    }

    /**
     * @param mixed $unusedSrc
     */
    public static function resolveInternalAwarditSession(
        $unusedSrc,
        array $unusedArgs,
        MageQL_Core_Model_Context $ctx
    ): ?Varien_Object {
        $session = Mage::getSingleton("customer/session");

        if (! $session->isLoggedIn()) {
            return null;
        }

        $customer = $session->getCustomer();
        $memberId = $customer->getAwarditMemberId();
        $sessionId = $session->getJavaSession();
        $deviceId = $session->getJavaDeviceSession();
        $partneruserid = $session->getJavaPartneruserid();

        if (! $memberId || ! $sessionId) {
            return null;
        }

        if (empty($partneruserid)) {
            $partneruserid = Mage::helper("awardit_points")->getPartnerId($ctx->getStore());
        }

        return new Varien_Object([
            "memberId" => $memberId,
            "partneruserid" => $partneruserid,
            "JSESSIONID" => $sessionId,
            "Cookie_2fa" => $deviceId,
        ]);
    }

    /**
     * @param mixed $unusedSrc
     */
    public static function resolveInternalAwarditPartneruserid(
        $unusedSrc,
        array $unusedArgs,
        MageQL_Core_Model_Context $ctx
    ): int {
        $partneruserid = Mage::helper("awardit_points")->getPartnerId($ctx->getStore());

        return (int)$partneruserid;
    }
}
