<?php

declare(strict_types=1);

use MageQL\ClientException;

class Awardit_Points_JavaSessionException extends ClientException
{
    public function __construct()
    {
        parent::__construct("Java session has expired");
    }

    public function isClientSafe()
    {
        return true;
    }

    public function getCategory()
    {
        return "awardit";
    }

    public function getExtensions(): array
    {
        return [
            "code" => "java_session_expired",
        ];
    }
}
