<?php

/**
 * @psalm-scope-this Mage_Customer_Model_Entity_Setup
 */
$installer = $this;

$installer->startSetup();

$conn = $installer->getConnection();
$amountType = [
    "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
    "nullable" => false,
    "default" => 0,
    "precision" => 10,
    "scale" => 2,
];

$conn->addColumn($this->getTable("sales/order"), "base_awardit_amount_tax", array_merge($amountType, ["comment" => "Amount of base_awardit_amount which is tax"]));
$conn->addColumn($this->getTable("sales/quote_address"), "base_awardit_amount_tax", array_merge($amountType, ["comment" => "Amount of base_awardit_amount which is tax"]));
$conn->addColumn($this->getTable("sales/order"), "awardit_amount_tax", array_merge($amountType, ["comment" => "Amount of awardit_amount which is tax"]));
$conn->addColumn($this->getTable("sales/quote_address"), "awardit_amount_tax", array_merge($amountType, ["comment" => "Amount of awardit_amount which is tax"]));

$installer->endSetup();
