<?php

/**
 * @psalm-scope-this Mage_Customer_Model_Entity_Setup
 */
$setup = $this;

$setup->startSetup();

$entityTypeId = $setup->getEntityTypeId("customer");
$attributeSetId = $setup->getDefaultAttributeSetId($entityTypeId);
$attributeGroupId = $setup->getDefaultAttributeGroupId($entityTypeId, $attributeSetId);

$setup->addAttribute("customer", "awardit_points_data",  array(
    "type" => "text",
    "nullable" => true,
    "backend"  => "",
    "label" => "Awardit Points JSON",
    "input" => "text",
    "source" => "",
    "sort_order" => 400,
    "visible" => false,
    "required" => false,
    "default" => null,
    "frontend" => "",
    "unique" => false,
    "note" => "",
));

foreach([
    "awardit_points_data" => ["position" => 570],
] as $attributeCode => $conf) {
    $setup->addAttributeToGroup(
        $entityTypeId,
        $attributeSetId,
        $attributeGroupId,
        $attributeCode,
        $conf["position"]
    );

    // We need to manually add the attribute here to be able to see it in admin
    $attribute = Mage::getSingleton("eav/config")->getAttribute("customer", $attributeCode);

    if( ! $attribute) {
        throw new Exception("Could not load customer attribute $attributeCode");
    }

    $attribute->setData("used_in_forms", ["adminhtml_customer"]);

    $attribute->save();
}

$setup->endSetup();
