<?php

/**
 * @psalm-scope-this Mage_Customer_Model_Entity_Setup
 */

$setup = $this;

$entityTypeId = $setup->getEntityTypeId("customer");
$attributeSetId = $setup->getDefaultAttributeSetId($entityTypeId);
$attributeGroupId = $setup->getDefaultAttributeGroupId($entityTypeId, $attributeSetId);

$setup->addAttribute("customer_address", "awardit_org_nr",  array(
    "type" => "varchar",
    "backend"  => "",
    "label" => "Customer Organization Number",
    "input" => "text",
    "source" => "",
    "sort_order" => 240,
    "visible" => true,
    "required" => false,
    "default" => "",
    "frontend" => "",
    "unique" => false,
    "note" => "Organizational number for customer",
));
$setup->addAttribute("customer", "awardit_salesgroup_id",  array(
    "type" => "varchar",
    "backend"  => "",
    "label" => "Awardit Salesgroup ID",
    "input" => "text",
    "source" => "",
    "sort_order" => 250,
    "visible" => true,
    "required" => false,
    "default" => "",
    "frontend" => "",
    "unique" => false,
    "note" => "ID of the salesgroup that the member is a part of.",
));
$setup->addAttribute("customer", "awardit_salesgroup_email",  array(
    "type" => "varchar",
    "backend"  => "",
    "label" => "Awardit Salesgroup Email",
    "input" => "text",
    "source" => "",
    "sort_order" => 260,
    "visible" => false,
    "required" => false,
    "default" => "",
    "frontend" => "",
    "unique" => false,
    "note" => "Email of salesgroup representative. Used as an invoicing reference.",
));

foreach(["awardit_salesgroup_id", "awardit_salesgroup_email"] as $a) {
    $setup->addAttributeToGroup(
        $entityTypeId,
        $attributeSetId,
        $attributeGroupId,
        $a,
        300
    );

    // We need to manually add the attribute here to be able to see it in admin
    $attribute = Mage::getSingleton("eav/config")->getAttribute("customer", $a);

    if( ! $attribute) {
        throw new Exception("Could not load customer attribute $a");
    }

    $attribute->setData("used_in_forms", ["adminhtml_customer"]);
    $attribute->save();
}

foreach(["awardit_org_nr"] as $a) {

    // We need to manually add the attribute here to be able to see it in admin
    $attribute = Mage::getSingleton("eav/config")->getAttribute("customer_address", $a);

    if( ! $attribute) {
        throw new Exception("Could not load customer address attribute $a");
    }

    $attribute->setData("used_in_forms", ["customer_address_edit","adminhtml_customer_address"]);
    $attribute->save();

}