<?php

/**
 * @psalm-scope-this Mage_Customer_Model_Entity_Setup
 */
$setup = $this;

$setup->startSetup();

$entityTypeId = $setup->getEntityTypeId("customer");
$attributeSetId = $setup->getDefaultAttributeSetId($entityTypeId);
$attributeGroupId = $setup->getDefaultAttributeGroupId($entityTypeId, $attributeSetId);

$setup->addAttribute("customer", "awardit_customer_extra2",  array(
    "type" => "varchar",
    "nullable" => true,
    "backend"  => "",
    "label" => "Awardit Customer Extra 2",
    "input" => "text",
    "source" => "",
    "sort_order" => 410,
    "visible" => true, // true will show field in GQL
    "required" => false,
    "default" => null,
    "frontend" => "",
    "unique" => false,
    "note" => "",
));
$setup->addAttribute("customer", "awardit_district",  array(
    "type" => "varchar",
    "nullable" => true,
    "backend"  => "",
    "label" => "Awardit District",
    "input" => "text",
    "source" => "",
    "sort_order" => 410,
    "visible" => true, // true will show field in GQL
    "required" => false,
    "default" => null,
    "frontend" => "",
    "unique" => false,
    "note" => "",
));
$setup->addAttribute("customer", "awardit_retailer",  array(
    "type" => "varchar",
    "nullable" => true,
    "backend"  => "",
    "label" => "Awardit Retailer",
    "input" => "text",
    "source" => "",
    "sort_order" => 410,
    "visible" => true, // true will show field in GQL
    "required" => false,
    "default" => null,
    "frontend" => "",
    "unique" => false,
    "note" => "",
));
$setup->addAttribute("customer", "awardit_ssn",  array(
    "type" => "varchar",
    "nullable" => true,
    "backend"  => "",
    "label" => "Awardit Social Security Number",
    "input" => "text",
    "source" => "",
    "sort_order" => 410,
    "visible" => true, // true will show field in GQL
    "required" => false,
    "default" => null,
    "frontend" => "",
    "unique" => false,
    "note" => "",
));

foreach([
    "awardit_customer_extra2" => ["position" => 360],
    "awardit_district" => ["position" => 580],
    "awardit_retailer" => ["position" => 590],
    "awardit_ssn" => ["position" => 600],
] as $attributeCode => $conf) {
    $setup->addAttributeToGroup(
        $entityTypeId,
        $attributeSetId,
        $attributeGroupId,
        $attributeCode,
        $conf["position"]
    );

    // We need to manually add the attribute here to be able to see it in admin
    $attribute = Mage::getSingleton("eav/config")->getAttribute("customer", $attributeCode);

    if( ! $attribute) {
        throw new Exception("Could not load customer attribute $attributeCode");
    }

    $attribute->setData("used_in_forms", ["adminhtml_customer"]);

    $attribute->save();
}

$setup->endSetup();
