<?php

/**
 * @psalm-import-type ApiPointsData from Awardit_Points_Model_Api
 * @psalm-import-type JavaSession from Awardit_Points_Model_Api
 */
class Awardit_Points_Helper_Data extends Mage_Core_Helper_Abstract {
    const CONFIG_ENABLED = "awardit_points/general/enabled";
    const CONFIG_LABEL = "awardit_points/general/label";
    const CONFIG_TEST = "awardit_points/general/test";
    const CONFIG_PARTNER_ID = "awardit_points/general/partner_id";
    const CONFIG_RATE = "awardit_points/general/base_rate";
    const CONFIG_SERVER = "awardit_points/server/host";
    const CONFIG_API_KEY = "awardit_points/server/api_key";
    const CONFIG_LISTID = "awardit_points/server/listid";
    const CONFIG_PRICE_MASTER = "awardit_points/redeem/price_master";

    protected function getRequired(Mage_Core_Model_Store $store, string $key): string {
        $value = $store->getConfig($key);

        if( ! $value) {
            throw new Exception(sprintf(
                "%s: %s is required",
                __CLASS__,
                $key
            ));
        }

        return $value;
    }

    public function isEnabled(Mage_Core_Model_Store $store): bool {
        return (bool)$store->getConfig(self::CONFIG_ENABLED);
    }

    public function getRate(Mage_Core_Model_Store $store): float {
        return (float)($store->getConfig(self::CONFIG_RATE) ?: 1);
    }

    public function getServer(Mage_Core_Model_Store $store): string {
        return $this->getRequired($store, self::CONFIG_SERVER);
    }

    public function getApiKey(Mage_Core_Model_Store $store): ?string {
        return $store->getConfig(self::CONFIG_API_KEY);
    }

    public function getPartnerId(Mage_Core_Model_Store $store): string {
        return $this->getRequired($store, self::CONFIG_PARTNER_ID);
    }

    public function getListId(Mage_Core_Model_Store $store): string {
        return $this->getRequired($store, self::CONFIG_LISTID);
    }

    public function getLabel(Mage_Core_Model_Store $store): string {
        return (string)$store->getConfig(self::CONFIG_LABEL);
    }

    public function isPriceMaster(Mage_Core_Model_Store $store): bool {
        return (bool)$store->getConfig(self::CONFIG_PRICE_MASTER);
    }

    /**
     * @return ?JavaSession
     */
    public function getJavaSession(): ?array {
        /**
         * @var Awardit_Points_SessionExtension
         */
        $session = Mage::getSingleton("customer/session");
        $sessionId = $session->getJavaSession();
        $deviceId = $session->getJavaDeviceSession();
        $partneruserid = $session->getJavaPartneruserid();
        $memberuserid = $session->getJavaMemberuserid();

        if(empty($sessionId)) {
            return null;
        }

        return [
            "JSESSIONID" => $sessionId,
            "Cookie_2fa" => $deviceId,
            "partneruserid" => empty($partneruserid) ? null : (int)$partneruserid,
            "memberuserid" => (string)$memberuserid,
        ];
    }

    /**
     * @param Awardit_Points_CustomerExtension $customer
     * @param ?ApiPointsData $pointsData
     */
    public function setCustomerPoints(Mage_Customer_Model_Customer $customer, $pointsData): void {
        $customer->setAwarditPointsData($pointsData ? json_encode($pointsData, JSON_PRESERVE_ZERO_FRACTION | JSON_UNESCAPED_SLASHES |  JSON_THROW_ON_ERROR) : "");
    }

    /**
     * Get request cookies
     *
     * @return array
     */
    public function getRequestCookies(): array {
        return $this->_getRequest()->getCookie();
    }
}
