<?php

declare(strict_types=1);

use MageQL\ClientException;

class Awardit_Points_Exception_NotEnoughPointsException
    extends ClientException {
    public function __construct() {
        parent::__construct("Not enough Awardit points available for purchase");
    }

    public function isClientSafe() {
        return true;
    }

    public function getCategory() {
        return "awardit_points";
    }

    public function getExtensions(): array {
        return [
            "code" => "errorNotEnoughPoints",
        ];
    }
}
