<?php

/**
 * @psalm-scope-this Mage_Customer_Model_Entity_Setup
 */
$setup = $this;

$setup->startSetup();

$entityTypeId = $setup->getEntityTypeId("customer");
$attributeSetId = $setup->getDefaultAttributeSetId($entityTypeId);
$attributeGroupId = $setup->getDefaultAttributeGroupId($entityTypeId, $attributeSetId);

$setup->addAttribute("customer", "awardit_customer_extra",  array(
    "type" => "varchar",
    "nullable" => true,
    "backend"  => "",
    "label" => "Awardit Customer Extra",
    "input" => "text",
    "source" => "",
    "sort_order" => 360,
    "visible" => true,
    "required" => false,
    "default" => null,
    "frontend" => "",
    "unique" => false,
    "note" => "Extra customer information data (careof field).",
));

$setup->addAttribute("customer", "awardit_totchildinhouse",  array(
    "type" => "int",
    "nullable" => true,
    "backend"  => "",
    "label" => "Awardit Employee Type/Budget/Goal/Whatever",
    "input" => "text",
    "source" => "",
    "sort_order" => 370,
    "visible" => true,
    "required" => false,
    "default" => null,
    "frontend" => "",
    "unique" => false,
    "note" => "Employee type, or budget, or sales goal, or maybe number of children, totchildinhouse can be anything",
));

foreach([
    "awardit_customer_extra" => ["position" => 360],
    "awardit_totchildinhouse" => ["position" => 370],
] as $attributeCode => $conf) {
    $setup->addAttributeToGroup(
        $entityTypeId,
        $attributeSetId,
        $attributeGroupId,
        $attributeCode,
        $conf["position"]
    );

    // We need to manually add the attribute here to be able to see it in admin
    $attribute = Mage::getSingleton("eav/config")->getAttribute("customer", $attributeCode);

    if( ! $attribute) {
        throw new Exception("Could not load customer attribute $attributeCode");
    }

    $attribute->setData("used_in_forms", ["adminhtml_customer"]);

    $attribute->save();
}

$setup->endSetup();