<?php

/**
 * @psalm-scope-this Mage_Customer_Model_Entity_Setup
 */
$installer = $this;

$conn = $installer->getConnection();

$amountType = [
    "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
    "nullable" => false,
    "default" => 0,
    "precision" => 10,
    "scale" => 2,
];
$memberIdType = [
    "type" => Varien_Db_Ddl_Table::TYPE_TEXT,
    "nullable" => true,
    "length" => 255,
    "comment" => "Awardit member id when using Awardit points",
];

$conn->addColumn($this->getTable("sales/quote_address"), "base_awardit_amount", array_merge($amountType, ["comment" => "Amount spent using Awardit points in base currency, not part of tax total"]));
$conn->addColumn($this->getTable("sales/quote_address"), "awardit_amount", array_merge($amountType, ["comment" => "Amount spent using Awardit points, not part of tax total"]));

$conn->dropColumn($this->getTable("sales/quote"), "base_awardit_amount");
$conn->dropColumn($this->getTable("sales/quote"), "awardit_amount");

$conn->addColumn($this->getTable("sales/order"), "awardit_member_id", $memberIdType);
$conn->addColumn($this->getTable("sales/quote"), "awardit_member_id", $memberIdType);
