<?php

$setup = new Mage_Eav_Model_Entity_Setup("core_setup");

$entityTypeId = $setup->getEntityTypeId("customer");
$attributeSetId = $setup->getDefaultAttributeSetId($entityTypeId);
$attributeGroupId = $setup->getDefaultAttributeGroupId($entityTypeId, $attributeSetId);

$setup->addAttribute("customer", "awardit_member_id",  array(
    "type" => "varchar",
    "backend"  => "",
    "label" => "Awardit Member ID",
    "input" => "text",
    "source" => "",
    "sort_order" => 220,
    "visible" => true,
    "required" => false,
    "default" => 0,
    "frontend" => "",
    "unique" => true,
    "note" => "Awardit member id",
));

$setup->addAttributeToGroup(
    $entityTypeId,
    $attributeSetId,
    $attributeGroupId,
    "awardit_member_id",
    220
);

// We need to manually add the attribute here to be able to see it in admin
$attribute = Mage::getSingleton("eav/config")->getAttribute("customer", "awardit_member_id");

if( ! $attribute) {
    throw new Exception("Could not load customer attribute awardit_member_id");
}

$attribute->setData("used_in_forms", ["adminhtml_customer"]);
$attribute->save();

