<?php

$setup = new Mage_Eav_Model_Entity_Setup("core_setup");

$entityTypeId = $setup->getEntityTypeId("customer");
$attributeSetId = $setup->getDefaultAttributeSetId($entityTypeId);
$attributeGroupId = $setup->getDefaultAttributeGroupId($entityTypeId, $attributeSetId);

$setup->addAttribute("customer", "awardit_points_expiring",  array(
    "type" => "int",
    "backend"  => "",
    "label" => "Awardit Points Expiring",
    "input" => "text",
    "source" => "",
    "sort_order" => 210,
    "visible" => true,
    "required" => false,
    "default" => 0,
    "frontend" => "",
    "unique" => false,
    "note" => "Awardit expiring at Awardit Points Expiring Date, will be updated upoon login and checkout",
));
$setup->addAttribute("customer", "awardit_points_expiring_date",  array(
    "type" => "varchar",
    "backend"  => "",
    "label" => "Awardit Points Expiring Date",
    "input" => "text",
    "source" => "",
    "sort_order" => 220,
    "visible" => true,
    "required" => false,
    "default" => "",
    "frontend" => "",
    "unique" => false,
    "note" => "Date the earliest part of awardit points will be expiring, will be updated upoon login and checkout",
));
$setup->addAttribute("customer", "awardit_rank",  array(
    "type" => "int",
    "backend"  => "",
    "label" => "Awardit Rank",
    "input" => "text",
    "source" => "",
    "sort_order" => 230,
    "visible" => true,
    "required" => false,
    "default" => 0,
    "frontend" => "",
    "unique" => false,
    "note" => "Total Awardit points earned by the customer, will be updated upoon login and checkout",
));

foreach(["awardit_points_expiring", "awardit_points_expiring_date", "awardit_rank"] as $a) {
    $setup->addAttributeToGroup(
        $entityTypeId,
        $attributeSetId,
        $attributeGroupId,
        $a,
        300
    );

    // We need to manually add the attribute here to be able to see it in admin
    $attribute = Mage::getSingleton("eav/config")->getAttribute("customer", $a);

    if( ! $attribute) {
        throw new Exception("Could not load customer attribute $a");
    }

    $attribute->setData("used_in_forms", ["adminhtml_customer"]);
    $attribute->save();
}
