<?php

/**
 * @psalm-scope-this Mage_Customer_Model_Entity_Setup
 */
$setup = $this;

$setup->startSetup();

$tableOptions = $setup->getTable('eav_attribute_option');
$tableOptionValues = $setup->getTable('eav_attribute_option_value');

$attributeId = (int) $setup->getAttribute('customer', 'gender', 'attribute_id');
$attributeLabel = 'Unspecified';

$data = array(
    'attribute_id' => $attributeId,
    'sort_order' => 99,
);

$setup->getConnection()->insert($tableOptions, $data);

$optionId = (int) $setup->getConnection()->lastInsertId($tableOptions, 'option_id');

$data = array(
    'option_id' => $optionId,
    'store_id' => 0,
    'value' => $attributeLabel,
);

$setup->getConnection()->insert($tableOptionValues, $data);

$setup->endSetup();