<?php

/**
 * @psalm-scope-this Mage_Customer_Model_Entity_Setup
 */
$installer = $this;
$installer->startSetup();
$setup = Mage::getResourceModel("catalog/setup", "catalog_setup");
$entityTypeId = (int) Mage::getModel("catalog/product")->getResource()->getEntityType()->getId();
$attributeGroupName = "Awardit";
$attributeSetName = "Default";
$attributeSetId = $this->getAttributeSetId($entityTypeId, $attributeSetName);

// Add product attribute awardit_target_id
$newAttributes = [
    "awardit_restriction_pid" => [
        "label" => "ID of restricted partner",
        "note" => "Purchase restricted by points earned from this partner (ID)",
        "group" => "Awardit",
        "sort_order" => 200,
        "backend" => "",
        "type" => "varchar",
        "frontend" => "",
        "note" => "",
        "default" => "",
        "wysiwyg_enabled" => false,
        "input" => "text",
        "input_renderer" => "",
        "source" => "",
        "required" => false,
        "user_defined" => false,
        "unique" => false,
        "global" => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        "visible" => true,
        "visible_on_front" => true,
        "used_in_product_listing" => true,
        "searchable" => false,
        "visible_in_advanced_search" => false,
        "filterable" => false,
        "filterable_in_search" => false,
        "comparable" => false,
        "is_html_allowed_on_front" => false,
        "apply_to" => "simple,virtual",
        "is_configurable" => false,
        "used_for_sort_by" => false,
        "position" => 0,
        "used_for_promo_rules" => false,
    ],
    "awardit_restriction_pname" => [
        "label" => "Name of restricted partner",
        "note" => "Purchase restricted by points earned from this partner (Name)",
        "group" => "Awardit",
        "sort_order" => 210,
        "backend" => "",
        "type" => "varchar",
        "frontend" => "",
        "note" => "",
        "default" => "",
        "wysiwyg_enabled" => false,
        "input" => "text",
        "input_renderer" => "",
        "source" => "",
        "required" => false,
        "user_defined" => false,
        "unique" => false,
        "global" => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        "visible" => true,
        "visible_on_front" => true,
        "used_in_product_listing" => true,
        "searchable" => false,
        "visible_in_advanced_search" => false,
        "filterable" => false,
        "filterable_in_search" => false,
        "comparable" => false,
        "is_html_allowed_on_front" => false,
        "apply_to" => "simple,virtual",
        "is_configurable" => false,
        "used_for_sort_by" => false,
        "position" => 0,
        "used_for_promo_rules" => false,
    ],
];

$attributeSetData = [
    "awardit_restriction_pid" => [
        "sort_order" => 6,
    ],
    "awardit_restriction_pname" => [
        "sort_order" => 5,
    ],
];

foreach ($newAttributes as $attributeName => $attributeData) {

    // Check if attribute already exists
    if (!$setup->getAttributeId(Mage_Catalog_Model_Product::ENTITY, $attributeName)) {

        // Add new attributes
        $setup->addAttribute(Mage_Catalog_Model_Product::ENTITY, $attributeName, $attributeData);

        // Add attribute to default attribute set
        $setup->addAttributeToSet($entityTypeId, $attributeSetId, $attributeGroupName, $attributeName, $attributeSetData[$attributeName]["sort_order"]);
    }
}

// By default Magento adds newly created attributes to all attribute sets.
// This removes them from all attribute sets EXCEPT "Default"
if (!empty($attributeSetId)) {
    $sqlQuery1 = "DELETE FROM eav_entity_attribute WHERE attribute_set_id != :attributeSetId AND attribute_id IN (SELECT attribute_id FROM eav_attribute WHERE attribute_code IN ('awardit_restriction_pid','awardit_restriction_pname'))";
    $stm1 = Mage::getSingleton("core/resource")->getConnection("core_setup")->prepare($sqlQuery1);
    $stm1->execute(["attributeSetId" => $attributeSetId]);
}


$quoteColumns = [
    "awardit_point_source_restriction" => [
        "type" => Varien_Db_Ddl_Table::TYPE_TEXT,
        "length" => 64,
        "nullable" => true,
        "comment" => "If specified, restrict purchase to only use points from specified partner id",
    ],
];

// Add new columns
$conn = $installer->getConnection();
foreach($quoteColumns as $col => $spec) {
    $conn->addColumn($this->getTable("sales/quote"), $col, $spec);
    $conn->addColumn($this->getTable("sales/order"), $col, $spec);
}

$installer->endSetup();
